<?php
/**
 * @copyright  Vertex. All rights reserved.  https://www.vertexinc.com/
 * @author     Mediotype                     https://www.mediotype.com/
 */

namespace Vertex\Tax\Model\Api\Service;

use Vertex\Services\TaxAreaLookup;
use Vertex\Services\TaxAreaLookupFactory as SdkTaxAreaLookupFactory;
use Vertex\Tax\Model\Api\ConfigBuilder;

/**
 * Create a {@see TaxAreaLookup} service class
 */
class TaxAreaLookupBuilder
{
    /** @var ConfigBuilder */
    private $configBuilder;

    /** @var SdkTaxAreaLookupFactory */
    private $sdkFactory;

    /** @var string */
    private $storeCode;

    /**
     * @param ConfigBuilder $configBuilder
     * @param SdkTaxAreaLookupFactory $sdkFactory
     */
    public function __construct(
        ConfigBuilder $configBuilder,
        SdkTaxAreaLookupFactory $sdkFactory
    ) {
        $this->configBuilder = $configBuilder;
        $this->sdkFactory = $sdkFactory;
    }

    /**
     * Create a Tax Area Lookup Service
     *
     * @return TaxAreaLookup
     */
    public function build()
    {
        $config = $this->configBuilder->setStoreCode($this->storeCode)
            ->build();

        return $this->sdkFactory->create(
            [
                'configuration' => $config,
            ]
        );
    }

    /**
     * Set the Store Code
     *
     * @param string|null $storeCode
     * @return TaxAreaLookupBuilder
     */
    public function setStoreCode($storeCode)
    {
        $this->storeCode = $storeCode;
        return $this;
    }
}
