<?php
/**
 * @copyright  Vertex. All rights reserved.  https://www.vertexinc.com/
 * @author     Mediotype                     https://www.mediotype.com/
 */

namespace Vertex\Tax\Model\Api\Service;

use Vertex\Services\Quote;
use Vertex\Services\QuoteFactory as SdkQuoteFactory;
use Vertex\Tax\Model\Api\ConfigBuilder;

/**
 * Create a {@see Quote} service class
 */
class QuoteBuilder
{
    /** @var ConfigBuilder */
    private $configBuilder;

    /** @var SdkQuoteFactory */
    private $sdkFactory;

    /** @var string */
    private $storeCode;

    /**
     * @param ConfigBuilder $configBuilder
     * @param SdkQuoteFactory $sdkFactory
     */
    public function __construct(
        ConfigBuilder $configBuilder,
        SdkQuoteFactory $sdkFactory
    ) {
        $this->configBuilder = $configBuilder;
        $this->sdkFactory = $sdkFactory;
    }

    /**
     * Create a Quote Service
     *
     * @return Quote
     */
    public function build()
    {
        $config = $this->configBuilder->setStoreCode($this->storeCode)
            ->build();

        return $this->sdkFactory->create(
            [
                'configuration' => $config,
            ]
        );
    }

    /**
     * Set the Store Code
     *
     * @param string|null $storeCode
     * @return QuoteBuilder
     */
    public function setStoreCode($storeCode)
    {
        $this->storeCode = $storeCode;
        return $this;
    }
}
