<?php
/**
 * @copyright  Vertex. All rights reserved.  https://www.vertexinc.com/
 * @author     Mediotype                     https://www.mediotype.com/
 */

namespace Vertex\Tax\Test\Integration\ApiExceptions;

use Magento\Framework\App\Config\Storage\WriterInterface;
use Vertex\Tax\Api\ClientInterface;
use Vertex\Tax\Model\ApiClient;
use Vertex\Tax\Model\Config;
use Vertex\Tax\Test\Integration\TestCase;

/**
 * Ensure that making an API Request with an incomplete company address results in a generic exception
 */
class IncompleteCompanyAddressTest extends TestCase
{
    /** @var ApiClient */
    private $apiClient;

    /** @var WriterInterface */
    private $configWriter;

    /**
     * @inheritdoc
     */
    protected function setUp()
    {
        parent::setUp();

        $om = $this->getObjectManager();
        $this->configWriter = $om->get(WriterInterface::class);

        // We're mocking the SOAP Response, as we don't want to hit the real API during testing
        $soapFactory = $this->getSoapFactory();
        $soap = $this->getMockBuilder(\SoapClient::class)
            ->disableOriginalConstructor()
            ->disableProxyingToOriginalMethods()
            ->setMethods(['calculate'])
            ->getMock();
        $soapFactory->setSoapClient($soap);

        $fault = new \SoapFault(
            'soapenv:Client',
            'The LocationRole being added is invalid. This might be due to an invalid location or an invalid'
            . ' address field. Make sure that the locationRole is valid, and try again.'
        );

        $this->configWriter->save(Config::VERTEX_CALCULATION_FUNCTION, 'calculate');
        $soap->method('calculate')
            ->willThrowException($fault);

        $this->apiClient = $om->get(ClientInterface::class);
    }

    /**
     * Ensure that making an API Request with an incomplete company address results in a generic exception
     *
     * @expectedException \Vertex\Tax\Exception\ApiRequestException
     * @expectedExceptionMessage An unknown error occurred performing the request
     */
    public function testSomething()
    {
        $this->apiClient->performRequest([], 'quote');
    }
}
