<?php
/**
 * Copyright © Magento, Inc. All rights reserved.
 * See COPYING.txt for license details.
 */
declare(strict_types=1);

namespace PayPal\BraintreeGiftCard\Plugin;

use Magento\Catalog\Model\Product;
use Magento\Framework\Registry;
use Magento\GiftCard\Model\Catalog\Product\Type\Giftcard;
use PayPal\Braintree\Block\Paypal\ProductPage;

class ProductPageGiftCard
{
    /**
     * @param Registry $registry
     */
    public function __construct(
        protected readonly Registry $registry,
    ) {
    }

    /**
     * Get amount for Gift card product
     *
     * @param ProductPage $subject
     * @param float $result
     * @return float
     */
    public function afterGetAmount(
        ProductPage $subject,
        float $result
    ): float {
        /** @var Product $product */
        $product = $this->registry->registry('product');

        if ($product && $product->getTypeId() === Giftcard::TYPE_GIFTCARD) {
            return (float) $product->getOpenAmountMin();
        }

        return $result;
    }
}
