define([
    'uiComponent',
    'jquery',
    'ko',
    'uiRegistry'
], function (Component, $, ko, registry) {
    'use strict';
    return Component.extend({
        defaults: {
            addNewCardVM: {
                visible: ko.observable(false)
            },
            addNewPayPalVM: {
                visible: ko.observable(false)
            },
            addNewGooglePayVM: {
                visible: ko.observable(false)
            },
            errorModalVM: {
                visible: ko.observable(false),
                message: ko.observable(null),
                header: ko.observable('Error')
            }
        },

        /**
         * Add the repeat order block to the frontend
         */
        initialize: function () {
            this.modifyKnockoutRemovalBehaviour();

            this._super();
        },

        /**
         * By moving the billing address form inside of Knockout it
         * conflicts with the mage.directoryRegionUpdater widget.
         *
         * Knockout will run a cleanData method that removes jQuery events so removes the region updater events
         * so User's will no longer see the correct region fields.
         */
        modifyKnockoutRemovalBehaviour: function () {
            const normalFunction = ko.utils.domNodeDisposal.cleanExternalData;

            ko.utils.domNodeDisposal.cleanExternalData = function (node) {
                if (node.id === 'country') {
                    return;
                }

                normalFunction(node);
            };
        },

        /**
         * Show add card modal
         */
        showAddCardModal: function () {
            this.addNewCardVM.visible(true);

            $('html, body').animate({scrollTop: 0}, 400);
        },

        /**
         * Hide add card modal
         */
        hideAddCardModal: function () {
            this.addNewCardVM.visible(false);
        },

        /**
         * Show add PayPal modal
         */
        showAddPayPalModal: function () {
            let braintreePaypal = registry.get('new-form-braintree-paypal');

            braintreePaypal.setup();
            this.addNewPayPalVM.visible(true);
        },

        /**
         * Show add PayPal modal
         */
        hideAddPayPalModal: function () {
            let braintreePaypal = registry.get('new-form-braintree-paypal');

            braintreePaypal.teardownPayPalInstance();
            this.addNewPayPalVM.visible(false);
        },

        /**
         * Show add Google Pay modal
         */
        showAddGooglePayModal: function () {
            let braintreeGooglePay = registry.get('new-form-braintree-google-pay');

            braintreeGooglePay.setup();
            this.addNewGooglePayVM.visible(true);
        },

        /**
         * Hide add Google Pay modal
         */
        hideAddGooglePayModal: function () {
            let braintreeGooglePay = registry.get('new-form-braintree-google-pay');

            braintreeGooglePay.teardown();
            this.addNewGooglePayVM.visible(false);
        }
    });
});
