/**
 * Braintree Apple Pay product page express integration.
 **/
define(
    [
        'jquery',
        'uiComponent',
        'PayPal_Braintree/js/applepay/button',
        'PayPal_Braintree/js/applepay/api',
        'PayPal_Braintree/js/helper/add-product-to-cart',
        'mage/translate',
        'domReady!'
    ],
    function (
        $,
        Component,
        button,
        buttonApi,
        addProductToCart,
        $t
    ) {
        'use strict';

        return Component.extend({

            defaults: {
                id: null,
                clientToken: null,
                quoteId: 0,
                displayName: null,
                actionSuccess: null,
                grandTotalAmount: 0,
                storeCode: 'default'
            },

            /**
             * @returns {Object}
             */
            initialize: function () {
                this._super();
                if (!this.displayName) {
                    this.displayName = $t('Store');
                }

                let api = new buttonApi();

                api.onButtonClick = (session) => {
                    addProductToCart(api)
                        .then(() => {
                            $('body').loader('hide');
                            session.begin();
                        })
                        .catch(() => {
                            $('body').loader('hide');
                        });
                }

                api.setGrandTotalAmount(parseFloat(this.grandTotalAmount).toFixed(2));
                api.setCurrencyCode(this.currencyCode);
                api.setClientToken(this.clientToken);
                api.setDisplayName(this.displayName);
                api.setQuoteId(this.quoteId);
                api.setActionSuccess(this.actionSuccess);
                api.setStoreCode(this.storeCode);
                api.setPriceIncludesTax(this.priceIncludesTax);

                // Attach the button
                button.init(
                    document.getElementById(this.id),
                    api
                );

                return this;
            }
        });
    }
);
