/**
 * Copyright (c) Meta Platforms, Inc. and affiliates.
 * All rights reserved.
 *
 * This source code is licensed under the BSD-style license found in the
 * LICENSE file in the root directory of this source tree. An additional grant
 * of patent rights can be found in the PATENTS file in the code directory.
 */
'use strict';

var React = require('./react');

var FBModal = React.createClass({
    displayName: 'Modal',

    render: function render() {
        return React.createElement(
            'div',
            { className: 'modal-container' },
            React.createElement(
                'div',
                { className: 'modal' },
                React.createElement(
                    'div',
                    { className: 'modal-header' },
                    this.props.title
                ),
                React.createElement(
                    'div',
                    { className: 'modal-content' },
                    this.props.message
                ),
                React.createElement(
                    'div',
                    { className: 'modal-close' },
                    React.createElement(
                        'button',
                        { onClick: this.props.onClose, className: 'medium blue' },
                        'OK'
                    )
                )
            )
        );
    }
});

module.exports = FBModal;
