<?php
/**
 * Copyright 2014 Adobe
 * All Rights Reserved.
 */
namespace Magento\Wishlist\Model;

/**
 * @api
 * @since 100.0.2
 */
class LocaleQuantityProcessor
{
    /**
     * @var \Magento\Framework\Locale\ResolverInterface
     */
    protected $localeResolver;

    /**
     * @var \Magento\Framework\Filter\LocalizedToNormalized
     */
    protected $localFilter;

    /**
     * @param \Magento\Framework\Locale\ResolverInterface $localeResolver
     * @param \Magento\Framework\Filter\LocalizedToNormalized $localFilter
     */
    public function __construct(
        \Magento\Framework\Locale\ResolverInterface $localeResolver,
        \Magento\Framework\Filter\LocalizedToNormalized $localFilter
    ) {
        $this->localeResolver = $localeResolver;
        $this->localFilter = $localFilter;
    }

    /**
     * Process localized quantity to internal format
     *
     * @param float $qty
     * @return array|string
     */
    public function process($qty)
    {
        $this->localFilter->setOptions(['locale' => $this->localeResolver->getLocale()]);
        $qty = $this->localFilter->filter((string)$qty);
        if ($qty < 0) {
            $qty = null;
        }

        return $qty;
    }
}
