<?php
/**
 * Copyright 2017 Adobe
 * All Rights Reserved.
 */
declare(strict_types=1);

namespace Magento\Ui\Test\Unit\Config\Converter;

use Magento\Ui\Config\Converter\StorageConfig;
use Magento\Ui\Config\ConverterInterface;
use Magento\Ui\Config\ConverterUtils;
use PHPUnit\Framework\MockObject\MockObject;
use PHPUnit\Framework\TestCase;

class StorageConfigTest extends TestCase
{
    /**
     * @var StorageConfig
     */
    private $converter;

    /**
     * @var ConverterInterface|MockObject
     */
    private $urlConverter;

    protected function setUp(): void
    {
        $this->urlConverter = $this->getMockBuilder(ConverterInterface::class)
            ->getMockForAbstractClass();
        $this->converter = new StorageConfig($this->urlConverter, new ConverterUtils());
    }

    public function testConvert()
    {
        $dom = new \DOMDocument('1.0', 'UTF-8');
        $dom->load(dirname(__FILE__) . DIRECTORY_SEPARATOR . '_files/test.xml');
        $domXpath = new \DOMXPath($dom);
        $storageConfig = $domXpath->query('//listing/settings/storageConfig')->item(0);
        $path = $domXpath->query('//listing/settings/storageConfig/path')->item(0);
        $urlResult = [
            'name' => 'path',
            'xsi:type' => 'url',
            'path' => 'path',
        ];
        $this->urlConverter->expects($this->any())
            ->method('convert')
            ->with($path, ['type' => 'url'])
            ->willReturn($urlResult);
        $expectedResult = [
            'name' => 'storageConfig',
            'xsi:type' => 'array',
            'item' => [
                'provider' => [
                    'name' => 'provider',
                    'xsi:type' => 'string',
                    'value' => 'provider',
                ],
                'namespace' => [
                    'name' => 'namespace',
                    'xsi:type' => 'string',
                    'value' => 'namespace',
                ],
                'path' => $urlResult,
                'test' => [
                    'name' => 'test',
                    'xsi:type' => 'string',
                    'value' => 'test',
                ]
            ],
        ];
        $this->assertEquals($expectedResult, $this->converter->convert($storageConfig));
    }
}
