/**
 * ADOBE CONFIDENTIAL
 *
 * Copyright 2017 Adobe
 * All Rights Reserved.
 *
 * NOTICE: All information contained herein is, and remains
 * the property of Adobe and its suppliers, if any. The intellectual
 * and technical concepts contained herein are proprietary to Adobe
 * and its suppliers and are protected by all applicable intellectual
 * property laws, including trade secret and copyright laws.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe.
 */

define([
    'uiComponent'
], function (UiComponent) {
    'use strict';

    return UiComponent.extend({
        defaults: {
            modules: {
                priceStorage: '${ $.priceStorage }'
            },
            listens: {
                '${ $.stepWizardPricingName }:close-modal': 'onEditComplete',
                '${ $.stepWizardName }:update-price': 'onEditComplete',
                '${ $.massactionName }:update-price': 'onEditComplete',
                '${ $.tierPriceFormName }:render-form': 'onEditComplete'
            }
        },

        /**
         * On grid edit complete.
         *
         * @param {Function|Undefined} callback
         * @private
         */
        onEditComplete: function (callback) {
            this.priceStorage().saveProductsCustomPrice().then(callback);
        }
    });
});
