/**
 * ADOBE CONFIDENTIAL
 *
 * Copyright 2016 Adobe
 * All Rights Reserved.
 *
 * NOTICE: All information contained herein is, and remains
 * the property of Adobe and its suppliers, if any. The intellectual
 * and technical concepts contained herein are proprietary to Adobe
 * and its suppliers and are protected by all applicable intellectual
 * property laws, including trade secret and copyright laws.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe.
 */

define([
    'jquery',
    'Magento_Ui/js/lib/validation/validator',
    'mage/translate'
], function ($, validator, $t) {
    'use strict';

    /**
     * Compare websites ids
     */
    function compareIds(currentId, rowId) {
        return currentId === rowId || currentId === 0 || rowId === 0;
    }

    return function (target) {

        /**
         * Validate shared catalog name length.
         */
        validator.addRule(
            'max-characters',
            function (value, params) {
                if ($.isNumeric(params)) {
                    return value.length <= parseInt(params, 10);
                }

                return true;
            },
            $t('The maximum allowed catalog name length is {0} characters.')
        );

        /**
         * Validate duplicate values of tier price in shared catalog.
         */
        validator.addRule(
            'validate-duplicate-values',
            function (value, params, data) {
                var isDuplicateValues = data.tierPriceData.filter(function (rowData) {
                    if (data.currentRowData && !rowData.delete && parseFloat(rowData.qty) === parseFloat(value) &&
                        data.currentRowData['record_id'] !== rowData['record_id'] &&
                        compareIds(data.currentRowData['website_id'], rowData['website_id'])
                    ) {
                        return true;
                    }
                });

                return !isDuplicateValues.length;
            },
            $t('Conflicting row.')
        );

        return target;
    };
});
