/**
 * ADOBE CONFIDENTIAL
 *
 * Copyright 2015 Adobe
 * All Rights Reserved.
 *
 * NOTICE: All information contained herein is, and remains
 * the property of Adobe and its suppliers, if any. The intellectual
 * and technical concepts contained herein are proprietary to Adobe
 * and its suppliers and are protected by all applicable intellectual
 * property laws, including trade secret and copyright laws.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe.
 */

define([
    'Magento_Ui/js/lib/step-wizard',
    'Magento_SharedCatalog/js/wizard',
    'uiComponent',
    'Magento_Ui/js/lib/spinner',
    'jquery',
    'underscore',
    'ko',
    'mage/backend/notification'
], function (uiStepWizard, Wizard, Component, loader, $, _) {
    'use strict';

    return uiStepWizard.extend({

        /**
         * Init component
         */
        initialize: function () {
            this._super();

            _.defer(_.bind(this.hideLoader, this));
        },

        /**
         * Open step wizard
         */
        open: function () {
            this.selectedStep(_.first(this.stepsNames));
            this.wizard = new Wizard(this.steps);
            $('[data-role=step-wizard-dialog]').trigger('openModal');
        },

        /**
         * Close step wizard
         */
        close: function () {
            this.trigger('update-price', this._closeModal.bind(this));
        },

        /**
         * Close modal
         */
        _closeModal: function () {
            $('[data-role=step-wizard-dialog]').trigger('closeModal');
        },

        /**
         * Hides loader
         */
        hideLoader: function () {
            loader.get(this.name).hide();
        },

        /**
         * Shows loader
         */
        showLoader: function () {
            loader.get(this.name).show();
        },

        /**
         * Step back
         */
        back: function () {
            this.trigger('update-price', this._super.bind(this));
        }
    });
});
