/**
 * ADOBE CONFIDENTIAL
 *
 * Copyright 2016 Adobe
 * All Rights Reserved.
 *
 * NOTICE: All information contained herein is, and remains
 * the property of Adobe and its suppliers, if any. The intellectual
 * and technical concepts contained herein are proprietary to Adobe
 * and its suppliers and are protected by all applicable intellectual
 * property laws, including trade secret and copyright laws.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe.
 */

define([
    'Magento_Ui/js/grid/controls/bookmarks/storage'
], function (Storage) {
    'use strict';

    return Storage.extend({
        defaults: {
            isSaveEnabled: true
        },

        /**
         * Sends request to store specified data.
         *
         * @param {String} path - Path by which data should be stored.
         * @param {*} value - Value to be sent.
         */
        set: function (path, value) {
            if (!this.isSaveEnabled) {
                return;
            }
            this._super(path, value);
        }
    });
});
