<?php

/**
 * ADOBE CONFIDENTIAL
 *
 * Copyright 2024 Adobe
 * All Rights Reserved.
 *
 * NOTICE: All information contained herein is, and remains
 * the property of Adobe and its suppliers, if any. The intellectual
 * and technical concepts contained herein are proprietary to Adobe
 * and its suppliers and are protected by all applicable intellectual
 * property laws, including trade secret and copyright laws.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe.
 */
declare(strict_types=1);

namespace Magento\SharedCatalog\ViewModel\Store;

use Magento\Backend\Model\Auth\Session;
use Magento\Framework\View\Element\Block\ArgumentInterface;
use Magento\Store\Model\ResourceModel\Website\CollectionFactory;
use Magento\Store\Model\Store;

class SwitcherAllowedValues implements ArgumentInterface
{
    /**
     * @var array
     */
    private $allWebsiteIds = [];

    /**
     * @param Session $backendAuthSession
     * @param CollectionFactory $websiteCollectionFactory
     */
    public function __construct(
        private readonly Session $backendAuthSession,
        private readonly CollectionFactory $websiteCollectionFactory
    ) {
    }

    /**
     * Get restricted admin user's an allowed option value.
     *
     * @return string
     */
    public function getSelectedOptionValue(): string
    {
        $role = $this->backendAuthSession->getUser()->getRole();
        $allowedWebsites = $role->getGwsWebsites() ?? [];
        if (!$role->getGwsIsAll()
            && count(array_diff($this->getAllWebsiteIds(), $allowedWebsites)) !== 0
            && $role->getGwsStoreGroups()) {
            return current($role->getGwsStoreGroups());
        }
        return (string)Store::DEFAULT_STORE_ID;
    }

    /**
     * Get all website ids excluding admin store.
     *
     * @return array
     */
    private function getAllWebsiteIds(): array
    {
        if (!count($this->allWebsiteIds)) {
            $this->allWebsiteIds = array_filter($this->websiteCollectionFactory->create()->getAllIds());
        }

        return  $this->allWebsiteIds;
    }
}
