<?php
/**
 * ADOBE CONFIDENTIAL
 *
 * Copyright 2016 Adobe
 * All Rights Reserved.
 *
 * NOTICE: All information contained herein is, and remains
 * the property of Adobe and its suppliers, if any. The intellectual
 * and technical concepts contained herein are proprietary to Adobe
 * and its suppliers and are protected by all applicable intellectual
 * property laws, including trade secret and copyright laws.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe.
 */
namespace Magento\SharedCatalog\Ui\DataProvider\Product\Form\Modifier;

use Magento\Catalog\Model\Locator\LocatorInterface;
use Magento\Catalog\Ui\DataProvider\Product\Form\Modifier\AbstractModifier;
use Magento\SharedCatalog\Model\ProductSharedCatalogsLoader;

/**
 * Class SharedCatalog
 */
class SharedCatalog extends AbstractModifier
{
    /**
     * @var LocatorInterface
     */
    private $locator;

    /**
     * @var ProductSharedCatalogsLoader
     */
    private $productSharedCatalogsLoader;

    /**
     * @param LocatorInterface $locator
     * @param ProductSharedCatalogsLoader $productSharedCatalogsLoader
     */
    public function __construct(
        LocatorInterface $locator,
        ProductSharedCatalogsLoader $productSharedCatalogsLoader
    ) {
        $this->locator = $locator;
        $this->productSharedCatalogsLoader = $productSharedCatalogsLoader;
    }

    /**
     * {@inheritdoc}
     */
    public function modifyData(array $data)
    {
        $product = $this->locator->getProduct();
        $sharedCatalogs = $this->productSharedCatalogsLoader->getAssignedSharedCatalogs($product->getSku());

        if ($sharedCatalogs) {
            foreach ($sharedCatalogs as $sharedCatalog) {
                $data[$product->getId()][self::DATA_SOURCE_DEFAULT]['shared_catalog'][] = $sharedCatalog->getId();
            }
        }
        return $data;
    }

    /**
     * {@inheritdoc}
     */
    public function modifyMeta(array $meta)
    {
        return $meta;
    }
}
