<?php
/**
 * ADOBE CONFIDENTIAL
 *
 * Copyright 2016 Adobe
 * All Rights Reserved.
 *
 * NOTICE: All information contained herein is, and remains
 * the property of Adobe and its suppliers, if any. The intellectual
 * and technical concepts contained herein are proprietary to Adobe
 * and its suppliers and are protected by all applicable intellectual
 * property laws, including trade secret and copyright laws.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe.
 */

namespace Magento\SharedCatalog\Ui\DataProvider\Product;

use Magento\Catalog\Model\ResourceModel\Product\Collection as ProductCollection;
use Magento\Framework\Data\Collection;

/**
 * Class that implements product filtering by shared catalog name on catalog products grid.
 */
class AddSharedCatalogFilterToCollection implements \Magento\Ui\DataProvider\AddFilterToCollectionInterface
{
    /**
     * {@inheritdoc}
     */
    public function addFilter(Collection $collection, $field, $condition = null)
    {
        if (is_array($condition) && isset($condition['in'])) {
            $collection->getSelect()->joinInner(
                ['scpi' => $collection->getTable('shared_catalog_product_item')],
                'scpi.sku=e.sku',
                []
            );
            $collection->getSelect()->joinInner(
                ['sc' => $collection->getTable('shared_catalog')],
                'sc.customer_group_id=scpi.customer_group_id',
                []
            )->where('sc.entity_id IN (?)', $condition['in']);
            $collection->distinct(true);
        }
    }
}
