<?php
/**
 * ADOBE CONFIDENTIAL
 *
 * Copyright 2016 Adobe
 * All Rights Reserved.
 *
 * NOTICE: All information contained herein is, and remains
 * the property of Adobe and its suppliers, if any. The intellectual
 * and technical concepts contained herein are proprietary to Adobe
 * and its suppliers and are protected by all applicable intellectual
 * property laws, including trade secret and copyright laws.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe.
 */
namespace Magento\SharedCatalog\Ui\DataProvider\Modifier\PriceByType;

use Magento\Ui\DataProvider\Modifier\ModifierInterface;
use Magento\SharedCatalog\Model\Form\Storage\PriceCalculator;
use Magento\SharedCatalog\Model\Form\Storage\UrlBuilder;

/**
 * Modifier for simple product.
 */
class Simple implements ModifierInterface
{
    /**
     * @var \Magento\SharedCatalog\Model\Form\Storage\PriceCalculator
     */
    private $priceCalculator;

    /**
     * @var \Magento\Framework\App\RequestInterface
     */
    private $request;

    /**
     * @param \Magento\Framework\App\RequestInterface $request
     * @param PriceCalculator $priceCalculator
     */
    public function __construct(
        \Magento\Framework\App\RequestInterface $request,
        PriceCalculator $priceCalculator
    ) {
        $this->request = $request;
        $this->priceCalculator = $priceCalculator;
    }

    /**
     * {@inheritdoc}
     */
    public function modifyData(array $data)
    {
        if (empty($data['entity_id']) || !isset($data['price'])) {
            return $data;
        }
        $data['new_price'] = $this->priceCalculator->calculateNewPriceForProduct(
            $this->request->getParam(UrlBuilder::REQUEST_PARAM_CONFIGURE_KEY),
            $data['sku'],
            $data['price'],
            $data['website_id']
        );

        return $data;
    }

    /**
     * {@inheritdoc}
     */
    public function modifyMeta(array $meta)
    {
        return $meta;
    }
}
