<?php
/**
 * ADOBE CONFIDENTIAL
 *
 * Copyright 2017 Adobe
 * All Rights Reserved.
 *
 * NOTICE: All information contained herein is, and remains
 * the property of Adobe and its suppliers, if any. The intellectual
 * and technical concepts contained herein are proprietary to Adobe
 * and its suppliers and are protected by all applicable intellectual
 * property laws, including trade secret and copyright laws.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe.
 */
namespace Magento\SharedCatalog\Ui\Component\Listing\Pricing;

use Magento\Framework\View\Element\UiComponent\ContextInterface;
use Magento\SharedCatalog\Model\Form\Storage\UrlBuilder;
use Magento\Ui\Component\Container;

/**
 * Price storage component.
 */
class PriceStorage extends Container
{
    /**
     * @var UrlBuilder
     */
    private $urlBuilder;

    /**
     * @param ContextInterface $context
     * @param UrlBuilder $urlBuilder
     * @param array $components
     * @param array $data
     */
    public function __construct(
        ContextInterface $context,
        UrlBuilder $urlBuilder,
        array $components = [],
        array $data = []
    ) {
        parent::__construct($context, $components, $data);
        $this->urlBuilder = $urlBuilder;
    }

    /**
     * @inheritDoc
     */
    public function prepare()
    {
        $this->prepareSaveUrl();
        parent::prepare();
    }

    /**
     * Prepare save url for editing client.
     *
     * @return $this
     */
    private function prepareSaveUrl()
    {
        if (!isset($this->_data['config']['clientConfig'])) {
            return $this;
        }
        $url = $this->urlBuilder->getUrl('shared_catalog/sharedCatalog_configure_product_price/save');
        $this->_data['config']['clientConfig']['saveUrl'] = $url;

        return $this;
    }
}
