<?php
/**
 * ADOBE CONFIDENTIAL
 *
 * Copyright 2025 Adobe
 * All Rights Reserved.
 *
 * NOTICE: All information contained herein is, and remains
 * the property of Adobe and its suppliers, if any. The intellectual
 * and technical concepts contained herein are proprietary to Adobe
 * and its suppliers and are protected by all applicable intellectual
 * property laws, including trade secret and copyright laws.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe.
 */
declare(strict_types=1);

namespace Magento\SharedCatalog\Test\Unit\Observer;

use Magento\Framework\Api\SearchCriteria;
use Magento\Framework\Api\SearchCriteriaBuilder;
use Magento\Framework\Event;
use Magento\Framework\Event\Observer;
use Magento\SharedCatalog\Api\Data\ProductItemInterface;
use Magento\SharedCatalog\Api\Data\ProductItemSearchResultsInterface;
use Magento\SharedCatalog\Api\ProductItemRepositoryInterface;
use Magento\SharedCatalog\Observer\DeleteImportProducts;
use PHPUnit\Framework\MockObject\MockObject;
use PHPUnit\Framework\TestCase;

class DeleteImportProductsTest extends TestCase
{
    /**
     * @var ProductItemRepositoryInterface|MockObject
     */
    private ProductItemRepositoryInterface $itemRepository;

    /**
     * @var SearchCriteriaBuilder|MockObject
     */
    private SearchCriteriaBuilder $searchCriteriaBuilder;

    /**
     * @inheritDoc
     */
    protected function setUp(): void
    {
        $this->itemRepository = $this->createMock(ProductItemRepositoryInterface::class);
        $this->searchCriteriaBuilder = $this->createMock(SearchCriteriaBuilder::class);
    }

    /**
     * Test that ProductItemRepositoryInterface::deleteItems method is being called
     *
     * @return void
     * @throws \PHPUnit\Framework\MockObject\Exception
     */
    public function testExecute(): void
    {
        $observer = $this->createMock(Observer::class);
        $event = $this->createMock(Event::class);
        $sku = 'sku1';
        $bunch = [
            ['sku' => $sku],
        ];
        $event->expects($this->once())->method('getData')->with('bunch')->willReturn($bunch);
        $observer->expects($this->once())->method('getEvent')->willReturn($event);

        $this->searchCriteriaBuilder->expects($this->once())
            ->method('addFilter')
            ->with(ProductItemInterface::SKU, [$sku], 'in');
        $searchCriteria = $this->createMock(SearchCriteria::class);
        $this->searchCriteriaBuilder->expects($this->once())->method('create')->willReturn($searchCriteria);
        $items = $this->createMock(ProductItemSearchResultsInterface::class);
        $productItem = $this->createMock(ProductItemInterface::class);
        $items->expects($this->once())->method('getItems')->willReturn([$productItem]);
        $this->itemRepository->expects($this->once())->method('getList')->willReturn($items);
        $this->itemRepository->expects($this->once())->method('deleteItems')->with([$productItem]);

        $instance = new DeleteImportProducts($this->itemRepository, $this->searchCriteriaBuilder);
        $instance->execute($observer);
    }
}
