<?php
/**
 * ADOBE CONFIDENTIAL
 *
 * Copyright 2017 Adobe
 * All Rights Reserved.
 *
 * NOTICE: All information contained herein is, and remains
 * the property of Adobe and its suppliers, if any. The intellectual
 * and technical concepts contained herein are proprietary to Adobe
 * and its suppliers and are protected by all applicable intellectual
 * property laws, including trade secret and copyright laws.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe.
 */
declare(strict_types=1);

namespace Magento\SharedCatalog\Test\Unit\Model;

use Magento\AsynchronousOperations\Api\Data\OperationListInterface;
use Magento\AsynchronousOperations\Api\Data\OperationListInterfaceFactory;
use Magento\Framework\MessageQueue\MergedMessageInterface;
use Magento\Framework\MessageQueue\MergedMessageInterfaceFactory;
use Magento\Framework\TestFramework\Unit\Helper\ObjectManager;
use Magento\SharedCatalog\Model\Merger;
use PHPUnit\Framework\MockObject\MockObject;
use PHPUnit\Framework\TestCase;

/**
 * Unit test for Merger.
 */
class MergerTest extends TestCase
{
    /**
     * @var OperationListInterfaceFactory|MockObject
     */
    private $operationListFactory;

    /**
     * @var MergedMessageInterfaceFactory|MockObject
     */
    private $mergedMessageFactory;

    /**
     * @var Merger
     */
    private $merger;

    /**
     * Set up.
     *
     * @return void
     */
    protected function setUp(): void
    {
        $this->operationListFactory = $this
            ->getMockBuilder(OperationListInterfaceFactory::class)
            ->onlyMethods(['create'])
            ->disableOriginalConstructor()
            ->getMockForAbstractClass();
        $this->mergedMessageFactory = $this
            ->getMockBuilder(MergedMessageInterfaceFactory::class)
            ->disableOriginalConstructor()
            ->onlyMethods(['create'])
            ->getMockForAbstractClass();

        $objectManager = new ObjectManager($this);
        $this->merger = $objectManager->getObject(
            Merger::class,
            [
                'operationListFactory' => $this->operationListFactory,
                'mergedMessageFactory' => $this->mergedMessageFactory,
            ]
        );
    }

    /**
     * Test for merge().
     *
     * @return void
     */
    public function testMerge()
    {
        $topicName = 'topic.name';
        $messages = [$topicName => [1 => 'message1', 2 => 'message2']];
        $operationList = $this->getMockBuilder(OperationListInterface::class)
            ->disableOriginalConstructor()
            ->getMockForAbstractClass();
        $this->operationListFactory->expects($this->atLeastOnce())->method('create')
            ->with(['items' => $messages[$topicName]])->willReturn($operationList);
        $mergedMessage = $this->getMockBuilder(MergedMessageInterface::class)
            ->disableOriginalConstructor()
            ->getMockForAbstractClass();
        $this->mergedMessageFactory->expects($this->atLeastOnce())->method('create')->willReturn($mergedMessage);

        $this->assertEquals([$topicName => [$mergedMessage]], $this->merger->merge($messages));
    }
}
