<?php
/**
 * ADOBE CONFIDENTIAL
 *
 * Copyright 2015 Adobe
 * All Rights Reserved.
 *
 * NOTICE: All information contained herein is, and remains
 * the property of Adobe and its suppliers, if any. The intellectual
 * and technical concepts contained herein are proprietary to Adobe
 * and its suppliers and are protected by all applicable intellectual
 * property laws, including trade secret and copyright laws.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe.
 */
declare(strict_types=1);

namespace Magento\SharedCatalog\Test\Unit\Controller\Adminhtml\SharedCatalog;

use ArrayIterator;

class MassDeleteTest extends MassTestCase
{
    protected $actionName = 'Delete';

    /**
     * Test for method execute.
     *
     * @return void
     */
    public function testExecute(): void
    {
        if (empty($this->actionName)) {
            return;
        }
        $testData = [
            $this->sharedCatalog,
            $this->sharedCatalog
        ];
        $this->sharedCatalogCollectionMock
            ->method('getIterator')
            ->willReturn(new ArrayIterator($testData));

        $this->groupExcludedWebsite
            ->expects(self::exactly(2))
            ->method('delete')
            ->willReturn(true);

        $this->messageManagerMock
            ->method('addSuccess')
            ->with(__('A total of %1 record(s) were deleted.', count($testData)));

        $this->resultRedirectMock
            ->method('setPath')
            ->with('shared_catalog/*/index')
            ->willReturnSelf();

        $this->massAction->execute();
    }
}
