<?php
/**
 * ADOBE CONFIDENTIAL
 *
 * Copyright 2016 Adobe
 * All Rights Reserved.
 *
 * NOTICE: All information contained herein is, and remains
 * the property of Adobe and its suppliers, if any. The intellectual
 * and technical concepts contained herein are proprietary to Adobe
 * and its suppliers and are protected by all applicable intellectual
 * property laws, including trade secret and copyright laws.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe.
 */
declare(strict_types=1);

namespace Magento\SharedCatalog\Test\Unit\Controller\Adminhtml\SharedCatalog\Company;

use Magento\Backend\App\Action\Context;
use Magento\Framework\App\RequestInterface;
use Magento\Framework\Controller\Result\Json;
use Magento\Framework\Controller\Result\JsonFactory;
use Magento\Framework\TestFramework\Unit\Helper\ObjectManager;
use Magento\SharedCatalog\Controller\Adminhtml\SharedCatalog\Company\Assign;
use Magento\SharedCatalog\Model\Form\Storage\Company;
use Magento\SharedCatalog\Model\Form\Storage\CompanyFactory;
use Magento\SharedCatalog\Model\Form\Storage\UrlBuilder;
use PHPUnit\Framework\MockObject\MockObject;
use PHPUnit\Framework\TestCase;

class AssignTest extends TestCase
{
    /**
     * @var Context|MockObject
     */
    protected $contextMock;

    /**
     * @var JsonFactory|MockObject
     */
    protected $resultJsonFactoryMock;

    /**
     * @var CompanyFactory|MockObject
     */
    protected $companyStorageFactoryMock;

    /**
     * @var Company|MockObject
     */
    protected $companyStorageMock;

    /**
     * @var RequestInterface|MockObject
     */
    protected $requestMock;

    /**
     * @var Assign|MockObject
     */
    protected $assignController;

    /**
     * Set up
     */
    protected function setUp(): void
    {
        $this->contextMock = $this->createPartialMock(Context::class, ['getRequest']);
        $this->requestMock = $this->getMockForAbstractClass(RequestInterface::class);
        $this->contextMock->expects($this->any())
            ->method('getRequest')
            ->willReturn($this->requestMock);
        $this->resultJsonFactoryMock =
            $this->createPartialMock(JsonFactory::class, ['create']);
        $this->companyStorageFactoryMock =
            $this->createPartialMock(CompanyFactory::class, ['create']);
        $this->companyStorageMock = $this->createPartialMock(
            Company::class,
            ['assignCompanies', 'isCompanyAssigned']
        );

        $objectManager = new ObjectManager($this);
        $this->assignController = $objectManager->getObject(
            Assign::class,
            [
                'context' => $this->contextMock,
                'resultJsonFactory' => $this->resultJsonFactoryMock,
                'companyStorageFactory' => $this->companyStorageFactoryMock
            ]
        );
    }

    /**
     * Test for method Execute
     */
    public function testExecute()
    {
        $sameId = 12;
        $this->requestMock
            ->expects($this->any())
            ->method('getParam')
            ->willReturnCallback(function ($arg1) use ($sameId) {
                if ($arg1 == UrlBuilder::REQUEST_PARAM_CONFIGURE_KEY) {
                    return $sameId;
                } elseif ($arg1 == 'company_id') {
                    return $sameId;
                } elseif ($arg1 == 'is_assign') {
                    return $sameId;
                }
            });
        $this->companyStorageFactoryMock->expects($this->once())
            ->method('create')
            ->willReturn($this->companyStorageMock);
        $json = $this->createMock(Json::class);
        $this->companyStorageMock->expects($this->any())->method('assignCompanies')->willReturnSelf();
        $json->expects($this->any())->method('setJsonData')->willReturnSelf();
        $this->companyStorageMock->expects($this->any())->method('isCompanyAssigned')->willReturn(true);
        $this->resultJsonFactoryMock->expects($this->any())
            ->method('create')->willReturn($json);

        $this->assignController->execute();
    }
}
