<?php
/**
 * ADOBE CONFIDENTIAL
 *
 * Copyright 2023 Adobe
 * All Rights Reserved.
 *
 * NOTICE: All information contained herein is, and remains
 * the property of Adobe and its suppliers, if any. The intellectual
 * and technical concepts contained herein are proprietary to Adobe
 * and its suppliers and are protected by all applicable intellectual
 * property laws, including trade secret and copyright laws.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe.
 */
declare(strict_types=1);

namespace Magento\SharedCatalog\Test\Fixture;

use Magento\Framework\Exception\NoSuchEntityException;
use Magento\Framework\Exception\InvalidArgumentException;
use Magento\Framework\DataObject;
use Magento\SharedCatalog\Api\CategoryManagementInterface;
use Magento\TestFramework\Fixture\DataFixtureInterface;

/**
 * Assigning category to shared catalog
 */
class AssignCategory implements DataFixtureInterface
{
    private const CATEGORY = 'category';
    private const CATALOG_ID = 'catalog_id';

    /**
     * @var CategoryManagementInterface
     */
    private CategoryManagementInterface $categoryManagement;

    /**
     * @param CategoryManagementInterface $categoryManagement
     */
    public function __construct(
        CategoryManagementInterface $categoryManagement
    ) {
        $this->categoryManagement = $categoryManagement;
    }

    /**
     * @inheritdoc
     * @throws InvalidArgumentException|NoSuchEntityException
     */
    public function apply(array $data = []): ?DataObject
    {
        if (empty($data[self::CATALOG_ID])) {
            throw new InvalidArgumentException(__('"%field" is required', ['field' => self::CATALOG_ID]));
        }

        if (empty($data[self::CATEGORY])) {
            throw new InvalidArgumentException(__('"%field" is required', ['field' => self::CATEGORY]));
        }

        $this->categoryManagement->assignCategories((int)$data[self::CATALOG_ID], [$data[self::CATEGORY]]);

        return null;
    }
}
