<?php
/**
 * ADOBE CONFIDENTIAL
 *
 * Copyright 2016 Adobe
 * All Rights Reserved.
 *
 * NOTICE: All information contained herein is, and remains
 * the property of Adobe and its suppliers, if any. The intellectual
 * and technical concepts contained herein are proprietary to Adobe
 * and its suppliers and are protected by all applicable intellectual
 * property laws, including trade secret and copyright laws.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe.
 */

namespace Magento\SharedCatalog\Plugin\Source;

use Magento\Framework\Api\Search\SearchCriteriaFactory;
use Magento\SharedCatalog\Api\SharedCatalogRepositoryInterface;

/**
 * Update options list of the customer group dropdown.
 */
class SharedCatalogGroupsProcessor
{
    /**
     * @var \Magento\SharedCatalog\Api\SharedCatalogRepositoryInterface
     */
    private $sharedCatalogRepository;

    /**
     * @var \Magento\Framework\Api\Search\SearchCriteriaFactory
     */
    private $searchCriteriaFactory;

    /**
     * @param SharedCatalogRepositoryInterface $sharedCatalogRepository
     * @param SearchCriteriaFactory $searchCriteriaFactory
     */
    public function __construct(
        SharedCatalogRepositoryInterface $sharedCatalogRepository,
        SearchCriteriaFactory $searchCriteriaFactory
    ) {
        $this->sharedCatalogRepository = $sharedCatalogRepository;
        $this->searchCriteriaFactory = $searchCriteriaFactory;
    }

    /**
     * Separate items by two groups: "Customer Group" and "Shared Catalog".
     *
     * @param array $groups
     * @return array
     * @throws \Magento\Framework\Exception\LocalizedException
     */
    public function prepareGroups(array $groups)
    {
        if (empty($groups)) {
            return $groups;
        }

        /** @var \Magento\Framework\Api\Search\SearchCriteriaInterface $searchCriteria */
        $searchCriteria = $this->searchCriteriaFactory->create();
        $sharedCatalogOptions = [];
        $sharedCatalogs = $this->sharedCatalogRepository->getList($searchCriteria);
        $values = array_column($groups, 'value');
        $customerGroupOptions = array_combine($values, $groups);

        /** @var \Magento\SharedCatalog\Api\Data\SharedCatalogInterface $sharedCatalog */
        foreach ($sharedCatalogs->getItems() as $sharedCatalog) {
            $sharedCatalogGroupId = $sharedCatalog->getCustomerGroupId();

            if (isset($customerGroupOptions[$sharedCatalogGroupId]) &&
                $customerGroupOptions[$sharedCatalogGroupId]['value'] == $sharedCatalogGroupId
            ) {
                unset($customerGroupOptions[$sharedCatalogGroupId]);

                $sharedCatalogOptions[] = [
                    'label' => $sharedCatalog->getName(),
                    'value' => $sharedCatalogGroupId,
                ];
            }
        }

        return [
            [
                'label' => sprintf('%s ', __('Customer Groups')),
                'value' => array_values($customerGroupOptions),
            ],
            [
                'label' => sprintf('%s ', __('Shared Catalogs')),
                'value' => $sharedCatalogOptions,
            ],
        ];
    }
}
