<?php
/**
 * ADOBE CONFIDENTIAL
 *
 * Copyright 2016 Adobe
 * All Rights Reserved.
 *
 * NOTICE: All information contained herein is, and remains
 * the property of Adobe and its suppliers, if any. The intellectual
 * and technical concepts contained herein are proprietary to Adobe
 * and its suppliers and are protected by all applicable intellectual
 * property laws, including trade secret and copyright laws.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe.
 */

namespace Magento\SharedCatalog\Plugin\Source;

class CustomerGroupPlugin
{
    /**
     * @var SharedCatalogGroupsProcessor
     */
    private $sharedCatalogGroupsProcessor;

    /**
     * CustomerGroupPlugin constructor.
     * @param SharedCatalogGroupsProcessor $sharedCatalogGroupsProcessor
     */
    public function __construct(SharedCatalogGroupsProcessor $sharedCatalogGroupsProcessor)
    {
        $this->sharedCatalogGroupsProcessor = $sharedCatalogGroupsProcessor;
    }

    /**
     * @param \Magento\Framework\Data\OptionSourceInterface $source
     * @param array $groups
     * @return array
     * @SuppressWarnings(PHPMD.UnusedFormalParameter)
     */
    public function afterToOptionArray(\Magento\Framework\Data\OptionSourceInterface $source, array $groups)
    {
        $result = $groups;
        $firstElement = current($groups);
        if (isset($firstElement['value']) && !is_array($firstElement['value'])) {
            $result = $this->sharedCatalogGroupsProcessor->prepareGroups($groups);
        }
        return $result;
    }

    /**
     * @param \Magento\Framework\Data\OptionSourceInterface $source
     * @param array $groups
     * @return array
     * @SuppressWarnings(PHPMD.UnusedFormalParameter)
     */
    public function afterGetAllOptions(\Magento\Framework\Data\OptionSourceInterface $source, array $groups)
    {
        return $this->sharedCatalogGroupsProcessor->prepareGroups($groups);
    }
}
