<?php
/**
 * ADOBE CONFIDENTIAL
 *
 * Copyright 2016 Adobe
 * All Rights Reserved.
 *
 * NOTICE: All information contained herein is, and remains
 * the property of Adobe and its suppliers, if any. The intellectual
 * and technical concepts contained herein are proprietary to Adobe
 * and its suppliers and are protected by all applicable intellectual
 * property laws, including trade secret and copyright laws.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe.
 */
namespace Magento\SharedCatalog\Plugin\SalesRule\Model\Rule\Metadata;

use Magento\SalesRule\Model\Rule\Metadata\ValueProvider;

/**
 * Class ValueProviderPlugin.
 */
class ValueProviderPlugin
{
    /**
     * Deletes all options from customer group field.
     *
     * @param ValueProvider $subject
     * @param array $result
     * @return array
     * @SuppressWarnings(PHPMD.UnusedFormalParameter)
     */
    public function afterGetMetadataValues(ValueProvider $subject, array $result)
    {
        if (!is_array($result)) {
            return $result;
        }
        if (isset($result['rule_information']['children']
            ['customer_group_ids']['arguments']['data']['config']['options'])) {
            $result['rule_information']['children']
            ['customer_group_ids']['arguments']['data']['config']['options'] = [];
        }
        return $result;
    }
}
