<?php
/**
 * ADOBE CONFIDENTIAL
 *
 * Copyright 2021 Adobe
 * All Rights Reserved.
 *
 * NOTICE: All information contained herein is, and remains
 * the property of Adobe and its suppliers, if any. The intellectual
 * and technical concepts contained herein are proprietary to Adobe
 * and its suppliers and are protected by all applicable intellectual
 * property laws, including trade secret and copyright laws.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe.
 */
namespace Magento\SharedCatalog\Plugin\Catalog\Model\ResourceModel\Category;

use Magento\Catalog\Api\Data\CategoryInterface;
use Magento\Catalog\Model\ResourceModel\Category as CategoryResource;

/**
 * Delete shared catalog permissions on category delete.
 */
class DeleteSharedCatalogCategoryPermissionsPlugin
{
    /**
     * @var \Magento\SharedCatalog\Model\ResourceModel\Permission
     */
    private $sharedCatalogPermissionResource;

    /**
     * @param \Magento\SharedCatalog\Model\ResourceModel\Permission $sharedCatalogPermissionResource
     */
    public function __construct(
        \Magento\SharedCatalog\Model\ResourceModel\Permission $sharedCatalogPermissionResource
    ) {
        $this->sharedCatalogPermissionResource = $sharedCatalogPermissionResource;
    }

    /**
     * Delete Shared Catalog category permissions after deleting category.
     *
     * @param CategoryResource $subject
     * @param CategoryResource $result
     * @param CategoryInterface $category
     * @return CategoryResource
     * @SuppressWarnings(PHPMD.UnusedFormalParameter)
     */
    public function afterDelete(
        CategoryResource $subject,
        CategoryResource $result,
        CategoryInterface $category
    ) {
        $this->sharedCatalogPermissionResource->deleteItems($category->getId());
        return $result;
    }
}
