<?php
/**
 * ADOBE CONFIDENTIAL
 *
 * Copyright 2016 Adobe
 * All Rights Reserved.
 *
 * NOTICE: All information contained herein is, and remains
 * the property of Adobe and its suppliers, if any. The intellectual
 * and technical concepts contained herein are proprietary to Adobe
 * and its suppliers and are protected by all applicable intellectual
 * property laws, including trade secret and copyright laws.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe.
 */

namespace Magento\SharedCatalog\Model\ResourceModel;

/**
 * ProductItem mysql resource.
 */
class ProductItem extends \Magento\Framework\Model\ResourceModel\Db\AbstractDb
{
    /**
     * @var int
     */
    private int $batchSize;

    /**
     * @param \Magento\Framework\Model\ResourceModel\Db\Context $context
     * @param int $batchSize
     * @param string $connectionName
     */
    public function __construct(
        \Magento\Framework\Model\ResourceModel\Db\Context $context,
        int $batchSize = 400,
        $connectionName = null
    ) {
        parent::__construct($context, $connectionName);
        $this->batchSize = $batchSize;
    }

    /**
     * Initialize resource model.
     *
     * @return void
     */
    protected function _construct()
    {
        $this->_init(
            'shared_catalog_product_item',
            'entity_id'
        );
    }

    /**
     * Create product links in bulk.
     *
     * @param array $skus
     * @param int $customerGroupId
     * @return int Number of added items
     */
    public function createItems(array $skus, $customerGroupId)
    {
        $data = [];
        foreach ($skus as $sku) {
            $data[] = ['sku' => $sku, 'customer_group_id' => $customerGroupId];
        }

        return $this->getConnection()->insertMultiple(
            $this->getTable('shared_catalog_product_item'),
            $data
        );
    }

    /**
     * Delete product links by SKUs in bulk.
     *
     * @param array $skus
     * @param int $customerGroupId
     * @return void
     */
    public function deleteItems(array $skus, $customerGroupId)
    {
        $tableName = $this
            ->getTable('shared_catalog_product_item');
        foreach (array_chunk($skus, $this->batchSize) as $skusBatch) {
            $select = $this->getConnection()->select()
                ->from($tableName)
                ->where('sku IN (?)', $skusBatch)
                ->where('customer_group_id = ?', $customerGroupId);

            $this->getConnection()->query($this->getConnection()->deleteFromSelect($select, $tableName));
        }
    }
}
