<?php
/**
 * ADOBE CONFIDENTIAL
 *
 * Copyright 2023 Adobe
 * All Rights Reserved.
 *
 * NOTICE: All information contained herein is, and remains
 * the property of Adobe and its suppliers, if any. The intellectual
 * and technical concepts contained herein are proprietary to Adobe
 * and its suppliers and are protected by all applicable intellectual
 * property laws, including trade secret and copyright laws.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe.
 */
declare(strict_types=1);

namespace Magento\SharedCatalog\Model;

use Magento\Framework\Exception\LocalizedException;
use Magento\SharedCatalog\Api\ResetTierPriceInterface;
use Magento\SharedCatalog\Api\SharedCatalogRepositoryInterface;

/**
 * Manage tier price for shared catalog
 */
class ResetTierPrice implements ResetTierPriceInterface
{
    /**
     * @var SharedCatalogRepositoryInterface
     */
    private SharedCatalogRepositoryInterface $sharedCatalogRepository;

    /**
     * @var TierPriceManagement
     */
    private TierPriceManagement $sharedCatalogTierPriceManagement;

    /**
     * Constructor
     *
     * @param SharedCatalogRepositoryInterface $sharedCatalogRepository
     * @param TierPriceManagement $sharedCatalogTierPriceManagement
     */
    public function __construct(
        SharedCatalogRepositoryInterface $sharedCatalogRepository,
        TierPriceManagement $sharedCatalogTierPriceManagement,
    ) {
        $this->sharedCatalogRepository = $sharedCatalogRepository;
        $this->sharedCatalogTierPriceManagement = $sharedCatalogTierPriceManagement;
    }

    /**
     * @inheritdoc
     */
    public function execute(int $sharedCatalogId, array $skus): void
    {
        try {
            $sharedCatalog = $this->sharedCatalogRepository->get($sharedCatalogId);
            $this->sharedCatalogTierPriceManagement->deleteProductTierPrices($sharedCatalog, array_values($skus), true);
        } catch (\Exception $e) {
            throw new LocalizedException(__('Failed to reset custom prices for shared catalog'), $e);
        }
    }
}
