<?php
/**
 * ADOBE CONFIDENTIAL
 *
 * Copyright 2017 Adobe
 * All Rights Reserved.
 *
 * NOTICE: All information contained herein is, and remains
 * the property of Adobe and its suppliers, if any. The intellectual
 * and technical concepts contained herein are proprietary to Adobe
 * and its suppliers and are protected by all applicable intellectual
 * property laws, including trade secret and copyright laws.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe.
 */
namespace Magento\SharedCatalog\Model\Indexer;

use Magento\CatalogPermissions\Model\Indexer\UpdateIndexInterface;
use Magento\Customer\Api\Data\GroupInterface;

/**
 * Copy index data in the table from default customer group
 */
class CopyCatalogPermissionsIndex implements UpdateIndexInterface
{
    /**
     * @var CopyIndex
     */
    private $copyIndex;

    /**
     * Constructor
     *
     * @param \Magento\SharedCatalog\Model\Indexer\CopyIndex $copyIndex
     */
    public function __construct(
        \Magento\SharedCatalog\Model\Indexer\CopyIndex $copyIndex
    ) {
        $this->copyIndex = $copyIndex;
    }

    /**
     * {@inheritdoc}
     */
    public function update(GroupInterface $group, $isGroupNew)
    {
        if (!$isGroupNew) {
            return;
        }
        $this->copyIndex->copy(
            $group,
            [
                'magento_catalogpermissions_index',
                'magento_catalogpermissions_index_product'
            ]
        );
    }
}
