<?php
/**
 * ADOBE CONFIDENTIAL
 *
 * Copyright 2016 Adobe
 * All Rights Reserved.
 *
 * NOTICE: All information contained herein is, and remains
 * the property of Adobe and its suppliers, if any. The intellectual
 * and technical concepts contained herein are proprietary to Adobe
 * and its suppliers and are protected by all applicable intellectual
 * property laws, including trade secret and copyright laws.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe.
 */
namespace Magento\SharedCatalog\Model\Form\Storage;

/**
 * Class UrlBuilder
 */
class UrlBuilder
{
    /**
     * Request param key
     */
    const REQUEST_PARAM_CONFIGURE_KEY = 'configure_key';

    /**
     * @var \Magento\Framework\UrlInterface
     */
    protected $urlBuilder;

    /**
     * @param \Magento\Framework\UrlInterface $urlBuilder
     */
    public function __construct(
        \Magento\Framework\UrlInterface $urlBuilder
    ) {
        $this->urlBuilder = $urlBuilder;
    }

    /**
     * Get url with configure key from request
     *
     * @param string|null $routePath
     * @param array $routeParams
     * @return string
     */
    public function getUrl($routePath = null, array $routeParams = [])
    {
        $routeParams['_current'] = self::REQUEST_PARAM_CONFIGURE_KEY;
        return $this->urlBuilder->getUrl($routePath, $routeParams);
    }
}
