<?php
/**
 * ADOBE CONFIDENTIAL
 *
 * Copyright 2022 Adobe
 * All Rights Reserved.
 *
 * NOTICE: All information contained herein is, and remains
 * the property of Adobe and its suppliers, if any. The intellectual
 * and technical concepts contained herein are proprietary to Adobe
 * and its suppliers and are protected by all applicable intellectual
 * property laws, including trade secret and copyright laws.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe.
 */
declare(strict_types=1);

namespace Magento\SharedCatalog\Model\Customer\Source;

use Magento\Config\Block\System\Config\Form;
use Magento\Framework\Data\OptionSourceInterface;
use Magento\SharedCatalog\Api\StatusInfoInterface;
use Magento\SharedCatalog\Model\Customer\Source\Collection\GroupFactory;

/**
 * List of customer groups with excluded shared catalog groups.
 */
class LandingGroup implements OptionSourceInterface
{
    /**
     * @var StatusInfoInterface
     */
    private $config;

    /**
     * @var Form
     */
    private $form;

    /**
     * @var GroupFactory
     */
    private $groupCollectionFactory;

    /**
     * @param StatusInfoInterface $config
     * @param Form $form
     * @param GroupFactory $groupCollectionFactory
     */
    public function __construct(
        StatusInfoInterface $config,
        Form $form,
        GroupFactory $groupCollectionFactory
    ) {
        $this->config = $config;
        $this->form = $form;
        $this->groupCollectionFactory = $groupCollectionFactory;
    }

    /**
     * @inheritdoc
     */
    public function toOptionArray()
    {
        $groupCollection = $this->groupCollectionFactory->create();
        $scopeType = $this->form->getScope();
        $scopeCode = $this->form->getScopeCode();
        if ($this->config->isActive($scopeType, $scopeCode)) {
            $groupCollection->joinSharedCatalogTable();
        }
        $groupCollection->load();

        return $groupCollection->toOptionArray();
    }
}
