<?php
/**
 * ADOBE CONFIDENTIAL
 *
 * Copyright 2018 Adobe
 * All Rights Reserved.
 *
 * NOTICE: All information contained herein is, and remains
 * the property of Adobe and its suppliers, if any. The intellectual
 * and technical concepts contained herein are proprietary to Adobe
 * and its suppliers and are protected by all applicable intellectual
 * property laws, including trade secret and copyright laws.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe.
 */
declare(strict_types=1);

namespace Magento\SharedCatalog\Model\Customer;

use Magento\Framework\Api\SearchCriteriaBuilder;
use Magento\SharedCatalog\Api\ProductItemRepositoryInterface;
use Magento\SharedCatalog\Api\Data\ProductItemInterface;

/**
 * Class for checking availability products for customer.
 */
class AvailableProducts
{
    /**
     * @var ProductItemRepositoryInterface
     */
    private $productItemRepository;

    /**
     * @var SearchCriteriaBuilder
     */
    private $searchCriteriaBuilder;

    /**
     * @param ProductItemRepositoryInterface $productItemRepository
     * @param SearchCriteriaBuilder $searchCriteriaBuilder
     */
    public function __construct(
        ProductItemRepositoryInterface $productItemRepository,
        SearchCriteriaBuilder $searchCriteriaBuilder
    ) {
        $this->productItemRepository = $productItemRepository;
        $this->searchCriteriaBuilder = $searchCriteriaBuilder;
    }

    /**
     * Check is product available for customer.
     *
     * @param int $customerGroupId
     * @param string $sku
     * @return bool
     */
    public function isProductAvailable(int $customerGroupId, string $sku): bool
    {
        $searchCriteriaBuilder = clone $this->searchCriteriaBuilder;
        $searchCriteriaBuilder->addFilter(ProductItemInterface::CUSTOMER_GROUP_ID, $customerGroupId);
        $searchCriteriaBuilder->addFilter(ProductItemInterface::SKU, $sku);
        $searchCriteria = $searchCriteriaBuilder->create();
        $searchResults = $this->productItemRepository->getList($searchCriteria);

        return (bool) $searchResults->getTotalCount();
    }
}
