<?php
/**
 * ADOBE CONFIDENTIAL
 *
 * Copyright 2016 Adobe
 * All Rights Reserved.
 *
 * NOTICE: All information contained herein is, and remains
 * the property of Adobe and its suppliers, if any. The intellectual
 * and technical concepts contained herein are proprietary to Adobe
 * and its suppliers and are protected by all applicable intellectual
 * property laws, including trade secret and copyright laws.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe.
 */
namespace Magento\SharedCatalog\Block\Adminhtml\SharedCatalog\Wizard\Step\Structure\Category;

/**
 * Display shared catalog categories tree at selecting products step.
 *
 * @api
 * @since 100.0.0
 */
class Tree extends \Magento\SharedCatalog\Block\Adminhtml\SharedCatalog\Wizard\Category\Tree
{
    /**#@+
     * Category tree routes
     */
    const TREE_INIT_ROUTE = 'shared_catalog/sharedCatalog/configure_tree_structure_get';
    const CATEGORY_ASSIGN_ROUTE = 'shared_catalog/sharedCatalog/configure_category_assign';
    /**#@-*/

    /**
     * Get URL for assigning categories.
     *
     * @return string
     */
    public function getAssignUrl()
    {
        return $this->urlBuilder->getUrl(self::CATEGORY_ASSIGN_ROUTE);
    }
}
