<?php
/**
 * ADOBE CONFIDENTIAL
 *
 * Copyright 2016 Adobe
 * All Rights Reserved.
 *
 * NOTICE: All information contained herein is, and remains
 * the property of Adobe and its suppliers, if any. The intellectual
 * and technical concepts contained herein are proprietary to Adobe
 * and its suppliers and are protected by all applicable intellectual
 * property laws, including trade secret and copyright laws.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe.
 */
namespace Magento\SharedCatalog\Block\Adminhtml\SharedCatalog\Edit;

use Magento\Framework\View\Element\UiComponent\Control\ButtonProviderInterface;
use Magento\SharedCatalog\Api\Data\SharedCatalogInterface;

/**
 * Button for duplicate shared catalog.
 */
class DuplicateSharedCatalogButton extends GenericButton implements ButtonProviderInterface
{
    /**
     * Get button configuration.
     *
     * @return array
     */
    public function getButtonData()
    {
        $data = [];
        if ($this->request->getActionName() == 'edit') {
            $data = [
                'label' => __('Duplicate'),
                'class' => 'duplicate',
                'data_attribute' => [
                    'mage-init' => [
                        'redirectionUrl' => ['url' => $this->getDuplicateUrl()],
                    ]
                ],
                'sort_order' => 50,
            ];
        }

        return $data;
    }

    /**
     * Get ulr for duplicate catalog.
     *
     * @return string
     */
    private function getDuplicateUrl()
    {
        $sharedCatalogId = $this->request->getParam(SharedCatalogInterface::SHARED_CATALOG_ID_URL_PARAM);
        return $this->getUrl(
            '*/*/duplicate',
            [SharedCatalogInterface::SHARED_CATALOG_ID_URL_PARAM => $sharedCatalogId]
        );
    }
}
