<?php
/**
 * ADOBE CONFIDENTIAL
 *
 * Copyright 2017 Adobe
 * All Rights Reserved.
 *
 * NOTICE: All information contained herein is, and remains
 * the property of Adobe and its suppliers, if any. The intellectual
 * and technical concepts contained herein are proprietary to Adobe
 * and its suppliers and are protected by all applicable intellectual
 * property laws, including trade secret and copyright laws.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe.
 */
namespace Magento\SharedCatalog\Api;

/**
 * Service for getting and setting status for stared catalog module.
 *
 * @api
 * @since 100.0.0
 */
interface StatusInfoInterface
{
    /**
     * Get shared catalog module active status for scope.
     *
     * @param string $scopeType
     * @param string|null $scopeCode
     * @return bool
     */
    public function isActive($scopeType, $scopeCode);

    /**
     * Get all store ids where Shared Catalog feature is switched on.
     *
     * @return array
     */
    public function getActiveSharedCatalogStoreIds();
}
