<?php
/**
 * ADOBE CONFIDENTIAL
 *
 * Copyright 2016 Adobe
 * All Rights Reserved.
 *
 * NOTICE: All information contained herein is, and remains
 * the property of Adobe and its suppliers, if any. The intellectual
 * and technical concepts contained herein are proprietary to Adobe
 * and its suppliers and are protected by all applicable intellectual
 * property laws, including trade secret and copyright laws.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe.
 */
namespace Magento\SharedCatalog\Api;

/**
 * Shared catalog products actions.
 * @api
 * @since 100.0.0
 */
interface ProductManagementInterface
{
    /**
     * Return the list of product SKUs in the selected shared catalog.
     *
     * @param int $id
     * @return string[]
     */
    public function getProducts($id);

    /**
     * Add products into the shared catalog.
     *
     * @param int $id
     * @param \Magento\Catalog\Api\Data\ProductInterface[] $products
     * @return bool true on success
     */
    public function assignProducts($id, array $products);

    /**
     * Remove the specified products from the shared catalog.
     *
     * @param int $id
     * @param \Magento\Catalog\Api\Data\ProductInterface[] $products
     * @return bool true on success
     */
    public function unassignProducts($id, array $products);

    /**
     * Reassign products to the shared catalog.
     *
     * @param \Magento\SharedCatalog\Api\Data\SharedCatalogInterface $sharedCatalog
     * @param array $skus
     * @return $this
     */
    public function reassignProducts(
        \Magento\SharedCatalog\Api\Data\SharedCatalogInterface $sharedCatalog,
        array $skus
    );
}
