<?php
/**
 * ADOBE CONFIDENTIAL
 *
 * Copyright 2016 Adobe
 * All Rights Reserved.
 *
 * NOTICE: All information contained herein is, and remains
 * the property of Adobe and its suppliers, if any. The intellectual
 * and technical concepts contained herein are proprietary to Adobe
 * and its suppliers and are protected by all applicable intellectual
 * property laws, including trade secret and copyright laws.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe.
 */
namespace Magento\SharedCatalog\Api\Data;

/**
 * Interface for Shared Catalog search results.
 * @api
 * @since 100.0.0
 */
interface SearchResultsInterface extends \Magento\Framework\Api\SearchResultsInterface
{
    /**
     * Get Shared Catalog list.
     *
     * @return \Magento\SharedCatalog\Api\Data\SharedCatalogInterface[]
     */
    public function getItems();

    /**
     * Set Shared Catalog list.
     *
     * @param \Magento\SharedCatalog\Api\Data\SharedCatalogInterface[] $items
     * @return $this
     */
    public function setItems(array $items);
}
