<?php
/**
 * ADOBE CONFIDENTIAL
 *
 * Copyright 2016 Adobe
 * All Rights Reserved.
 *
 * NOTICE: All information contained herein is, and remains
 * the property of Adobe and its suppliers, if any. The intellectual
 * and technical concepts contained herein are proprietary to Adobe
 * and its suppliers and are protected by all applicable intellectual
 * property laws, including trade secret and copyright laws.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe.
 */
namespace Magento\SharedCatalog\Api\Data;

use Magento\Framework\Api\SearchResultsInterface as FrameworkSearchResultsInterface;

/**
 * Interface for Shared Catalog Product Item search results.
 * @api
 * @since 100.0.0
 */
interface ProductItemSearchResultsInterface extends FrameworkSearchResultsInterface
{
    /**
     * Get Shared Catalog Product Item list.
     *
     * @return \Magento\SharedCatalog\Api\Data\ProductItemInterface[]
     */
    public function getItems();

    /**
     * Set Shared Catalog Product Item list.
     *
     * @param \Magento\SharedCatalog\Api\Data\ProductItemInterface[] $items
     * @return $this
     */
    public function setItems(array $items);
}
