<?php
/**
 * ADOBE CONFIDENTIAL
 *
 * Copyright 2016 Adobe
 * All Rights Reserved.
 *
 * NOTICE: All information contained herein is, and remains
 * the property of Adobe and its suppliers, if any. The intellectual
 * and technical concepts contained herein are proprietary to Adobe
 * and its suppliers and are protected by all applicable intellectual
 * property laws, including trade secret and copyright laws.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe.
 */
namespace Magento\SharedCatalog\Api;

/**
 * Shared catalog companies actions.
 * @api
 * @since 100.0.0
 */
interface CompanyManagementInterface
{
    /**
     * Return the list of company IDs for the companies assigned to the selected catalog.
     *
     * @param int $sharedCatalogId
     * @return string
     */
    public function getCompanies($sharedCatalogId);

    /**
     * Assign companies to a shared catalog.
     *
     * @param int $sharedCatalogId
     * @param \Magento\Company\Api\Data\CompanyInterface[] $companies
     * @return bool
     * @throws \Exception
     */
    public function assignCompanies($sharedCatalogId, array $companies);

    /**
     * Unassign companies from a shared catalog.
     *
     * @param int $sharedCatalogId
     * @param \Magento\Company\Api\Data\CompanyInterface[] $companies
     * @return bool
     * @throws \Magento\Framework\Exception\LocalizedException
     * @throws \Exception
     */
    public function unassignCompanies($sharedCatalogId, array $companies);

    /**
     * Unassign all companies from a shared catalog without validation.
     *
     * @param int $sharedCatalogId
     * @return bool
     * @throws \Exception
     */
    public function unassignAllCompanies($sharedCatalogId);
}
