/**
 * ADOBE CONFIDENTIAL
 *
 * Copyright 2016 Adobe
 * All Rights Reserved.
 *
 * NOTICE: All information contained herein is, and remains
 * the property of Adobe and its suppliers, if any. The intellectual
 * and technical concepts contained herein are proprietary to Adobe
 * and its suppliers and are protected by all applicable intellectual
 * property laws, including trade secret and copyright laws.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe.
 */

define([
    'Magento_SharedCatalog/js/store/switcher',
    'jquery',
    'underscore',
    'mage/translate'
], function (StoreSwitcher, $, _) {
    'use strict';

    return StoreSwitcher.extend({
        defaults: {
            modules: {
                treeProvider: '${ $.treeProvider }'
            },
            exports: {
                selectedStore: '${ $.treeProvider }:params.filters.store'
            },
            listens: {
                selectedStore: '_onSelectedStoreChanged'
            },
            storeElementSelector: ''
        },

        /**
         * Initialize component
         */
        initialize: function () {
            _.bindAll(this, '_onSelectedStoreChanged');

            this._super();
        },

        /**
         * On selected store changed
         *
         * @private
         */
        _onSelectedStoreChanged: function () {
            this._getStoreElement().val(this.selectedStore().id);
        },

        /**
         * Get store form element
         *
         * @returns {jQuery}
         * @private
         */
        _getStoreElement: function () {
            return $(this.storeElementSelector);
        }
    });
});
