/**
 * ADOBE CONFIDENTIAL
 *
 * Copyright 2017 Adobe
 * All Rights Reserved.
 *
 * NOTICE: All information contained herein is, and remains
 * the property of Adobe and its suppliers, if any. The intellectual
 * and technical concepts contained herein are proprietary to Adobe
 * and its suppliers and are protected by all applicable intellectual
 * property laws, including trade secret and copyright laws.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe.
 */

define([
    'Magento_Ui/js/grid/provider'
], function (GridProvider) {
    'use strict';

    return GridProvider.extend({
        defaults: {
            modules: {
                priceStorage: '${ $.priceStorage }'
            }
        },

        /** @inheritdoc */
        reload: function (options) {
            return this.saveTempData()
                .then(this._super.bind(this, options));
        },

        /**
         * Save temp data.
         *
         * @returns {jQuery.Promise}
         */
        saveTempData: function () {
            return this.priceStorage().saveProductsCustomPrice();
        }
    });
});
