/**
 * ADOBE CONFIDENTIAL
 *
 * Copyright 2016 Adobe
 * All Rights Reserved.
 *
 * NOTICE: All information contained herein is, and remains
 * the property of Adobe and its suppliers, if any. The intellectual
 * and technical concepts contained herein are proprietary to Adobe
 * and its suppliers and are protected by all applicable intellectual
 * property laws, including trade secret and copyright laws.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe.
 */
define([
    'jquery',
    'underscore'
], function ($, _) {
    'use strict';

    return {
        /**
         * Is valid price input event
         *
         * @param {Object} e
         * @returns {Boolean}
         */
        isDigits: function (e) {
            if (_.contains([8, 9, 27, 13, 110, 190], e.keyCode) ||
                e.keyCode === 65 && (e.ctrlKey === true || e.metaKey === true) ||
                e.keyCode >= 35 && e.keyCode <= 40) {
                return true;
            } else
            if ((e.shiftKey || (e.keyCode < 46 || e.keyCode > 57)) &&
                (e.keyCode < 96 || e.keyCode > 105)) {
                return false;
            }

            return true;
        }
    };
});
