/**
 * ADOBE CONFIDENTIAL
 *
 * Copyright 2017 Adobe
 * All Rights Reserved.
 *
 * NOTICE: All information contained herein is, and remains
 * the property of Adobe and its suppliers, if any. The intellectual
 * and technical concepts contained herein are proprietary to Adobe
 * and its suppliers and are protected by all applicable intellectual
 * property laws, including trade secret and copyright laws.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe.
 */

define([
    'jquery',
    'ko',
    'Magento_Ui/js/form/element/abstract'
], function ($, ko, Element) {
    'use strict';

    return Element.extend({
        defaults: {
            websiteFieldName: 'website_id',
            currencySymbolName: 'symbol',
            websiteField: '${ $.provider }:${ $.parentScope }.website_id',
            listens: {
                '${ $.websiteField }': 'setCurrencyCode'
            },
            imports: {
                parent: '${ $.provider }:${ $.parentScope }'
            }
        },

        /**
         * Initializes observable properties of instance
         *
         * @returns {Abstract} Chainable.
         */
        initObservable: function () {
            this._super();
            this.observe('addbefore');

            return this;
        },

        /**
         * Sets initial value of the element and subscribes to it's changes.
         *
         * @returns {Abstract} Chainable.
         */
        setInitialValue: function () {
            this._super()
                .setCurrencyCode(this.parent[this.websiteFieldName]);

            return this;
        },

        /**
         * Set new label for currency field
         *
         * @public
         */
        setCurrencyCode: function (id) {
            var source = typeof this.source === 'function' ? this.source() : this.source;

            source.data['base_currencies'].forEach(function (el) {
                if (el[this.websiteFieldName] == id) { //eslint-disable-line eqeqeq
                    this.set('addbefore', el[this.currencySymbolName]);
                }
            }, this);
        }
    });
});
