/**
 * ADOBE CONFIDENTIAL
 *
 * Copyright 2016 Adobe
 * All Rights Reserved.
 *
 * NOTICE: All information contained herein is, and remains
 * the property of Adobe and its suppliers, if any. The intellectual
 * and technical concepts contained herein are proprietary to Adobe
 * and its suppliers and are protected by all applicable intellectual
 * property laws, including trade secret and copyright laws.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe.
 */

define([
    'underscore',
    'uiLayout',
    'uiRegistry',
    'mage/translate',
    'Magento_SharedCatalog/js/grid/massactions'
], function (_, layout, registry, $t, Massactions) {
    'use strict';

    return Massactions.extend({
        defaults: {
            assignActionConfig: {
                name: '${ $.name }_action_assign'
            },
            unassignActionConfig: {
                name: '${ $.name }_action_unassign'
            },
            modules: {
                assignAction: '${ $.assignActionConfig.name }',
                unassignAction: '${ $.unassignActionConfig.name }'
            },
            actionComponents: {
                assign: 'assignAction',
                unassign: 'unassignAction'
            }
        },

        /**
         * Get actions components
         *
         * @returns {Array}
         */
        getActions: function () {
            return [this.assignActionConfig, this.unassignActionConfig];
        }
    });
});
