/**
 * ADOBE CONFIDENTIAL
 *
 * Copyright 2016 Adobe
 * All Rights Reserved.
 *
 * NOTICE: All information contained herein is, and remains
 * the property of Adobe and its suppliers, if any. The intellectual
 * and technical concepts contained herein are proprietary to Adobe
 * and its suppliers and are protected by all applicable intellectual
 * property laws, including trade secret and copyright laws.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe.
 */
define([
    'underscore',
    'uiLayout',
    'mage/translate',
    'Magento_Ui/js/grid/columns/select'
], function (_, layout, $t, Column) {
    'use strict';

    return Column.extend({
        defaults: {
            labelMaxLength: 15,
            labelSuffix: '...'
        },

        /**
         * Ment to preprocess data associated with a current columns' field.
         *
         * @param {Object} record - Data to be preprocessed.
         * @returns {String}
         */
        getLabel: function (record) {
            var name = this._super(record);

            if (name && name.length >= this.labelMaxLength - 1) {
                name = name.slice(0, this.labelMaxLength) + this.labelSuffix;
            }

            return name;
        }
    });
});
