<?php
/**
 * ADOBE CONFIDENTIAL
 *
 * Copyright 2015 Adobe
 * All Rights Reserved.
 *
 * NOTICE: All information contained herein is, and remains
 * the property of Adobe and its suppliers, if any. The intellectual
 * and technical concepts contained herein are proprietary to Adobe
 * and its suppliers and are protected by all applicable intellectual
 * property laws, including trade secret and copyright laws.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe.
 */
namespace Magento\SharedCatalog\Ui\Component\Listing\Column\Store;

/**
 * Store Options for Shared Catalog
 */
class Options extends \Magento\Store\Model\System\Store
{
    /**
     * @var array
     */
    protected $options;

    /**
     * @var array
     */
    protected $currentOptions = [];

    /**
     * Get options
     *
     * @return array
     */
    public function toOptionArray()
    {
        if ($this->options !== null) {
            return $this->options;
        }

        /** @var \Magento\Store\Model\Group $group */
        foreach ($this->getGroupCollection() as $group) {
            $this->currentOptions[$group->getName()]['label'] = $group->getName();
            $this->currentOptions[$group->getName()]['value'] = $group->getId();
        }

        $this->options = array_values($this->currentOptions);
        return $this->options;
    }
}
