<?php
/**
 * ADOBE CONFIDENTIAL
 *
 * Copyright 2022 Adobe
 * All Rights Reserved.
 *
 * NOTICE: All information contained herein is, and remains
 * the property of Adobe and its suppliers, if any. The intellectual
 * and technical concepts contained herein are proprietary to Adobe
 * and its suppliers and are protected by all applicable intellectual
 * property laws, including trade secret and copyright laws.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe.
 */
declare(strict_types=1);

namespace Magento\SharedCatalog\Test\Unit\Plugin\Ui\DataProvider;

use Magento\Authorization\Model\Role;
use Magento\Backend\Model\Auth\Session;
use Magento\Framework\Stdlib\ArrayManager;
use Magento\SharedCatalog\Plugin\Ui\DataProvider\WebsiteRolePermissions;
use Magento\SharedCatalog\Ui\DataProvider\Website;
use Magento\Store\Model\ResourceModel\Website\Collection;
use Magento\Store\Model\ResourceModel\Website\CollectionFactory;
use Magento\User\Model\User;
use PHPUnit\Framework\MockObject\MockObject;
use PHPUnit\Framework\TestCase;

/**
 * Unit test for WebsiteRolePermissions plugin.
 *
 */
class WebsiteRolePermissionsTest extends TestCase
{
    /**
     * @var ArrayManager|MockObject
     */
    private $arrayManagerMock;

    /**
     * @var Role|MockObject
     */
    private $roleMock;

    /**
     * @var User
     */
    private $userMock;

    /**
     * @var Session
     */
    private $backendSessionMock;

    /**
     * @var Website|MockObject
     */
    private $websiteMock;

    /**
     * @var WebsiteRolePermissions
     */
    private $websiteRolePermissions;

    /**
     * @var CollectionFactory|MockObject
     */
    private $websiteCollectionFactoryMock;

    /**
     * @var Collection|MockObject
     */
    private $websiteCollectionMock;

    protected function setUp(): void
    {
        $this->arrayManagerMock = $this->getMockBuilder(ArrayManager::class)
            ->disableOriginalConstructor()
            ->getMock();

        $this->userMock = $this->getMockBuilder(User::class)
            ->disableOriginalConstructor()
            ->onlyMethods(['getRole'])
            ->getMock();

        $this->roleMock = $this->getMockBuilder(Role::class)
            ->disableOriginalConstructor()
            ->addMethods(['getGwsIsAll'])
            ->getMock();

        $this->backendSessionMock = $this->getMockBuilder(Session::class)
            ->disableOriginalConstructor()
            ->addMethods(['getUser'])
            ->getMock();

        $this->websiteMock = $this->getMockBuilder(Website::class)
            ->disableOriginalConstructor()
            ->getMock();

        $this->websiteCollectionMock = $this->getMockBuilder(Collection::class)
            ->disableOriginalConstructor()
            ->getMock();

        $this->websiteCollectionFactoryMock = $this->getMockBuilder(CollectionFactory::class)
            ->disableOriginalConstructor()
            ->getMock();

        $this->websiteCollectionFactoryMock->expects($this->any())
            ->method('create')
            ->willReturn($this->websiteCollectionMock);

        $this->websiteCollectionMock->expects($this->any())
            ->method('getAllIds')
            ->willReturn([0, 1]);

        $this->websiteRolePermissions = new WebsiteRolePermissions(
            $this->backendSessionMock,
            $this->arrayManagerMock,
            $this->websiteCollectionFactoryMock
        );
    }

    /**
     * Test for afterGetWebsites().
     *
     * @return void
     * @dataProvider afterGetWebsitesDataProvider
     */
    public function testAfterGetWebsites($allWebsitesPermissions, $result, $exists, $finalResult)
    {
        $this->backendSessionMock->expects($this->once())
            ->method('getUser')
            ->willReturn($this->userMock);
        $this->userMock->expects($this->once())
            ->method('getRole')
            ->willReturn($this->roleMock);
        $this->roleMock->expects($this->once())
            ->method('getGwsIsAll')
            ->willReturn($allWebsitesPermissions);

        $this->arrayManagerMock->expects($this->any())
            ->method('exists')
            ->with(0, $result)
            ->willReturn($exists);

        $this->assertEquals(
            $finalResult,
            $this->websiteRolePermissions
                ->afterGetWebsites($this->websiteMock, $result)
        );
    }

    /**
     * Data provider for afterGetWebsites() test.
     *
     * @return array
     */
    public static function afterGetWebsitesDataProvider()
    {
        return [
            [
                0,
                [
                    0 => ['value' => 0, 'label' => 'All Store Views'],
                    1 => ['value' => 1, 'label' => 'Main Website Store', 'store_ids' => [1]]
                ],
                1,
                [
                    0 => ['value' => 1, 'label' => 'Main Website Store', 'store_ids' => [1]]
                ]
            ],
            [0, [], false, []],
            [1, [], false, []]
        ];
    }
}
