<?php
/**
 * ADOBE CONFIDENTIAL
 *
 * Copyright 2020 Adobe
 * All Rights Reserved.
 *
 * NOTICE: All information contained herein is, and remains
 * the property of Adobe and its suppliers, if any. The intellectual
 * and technical concepts contained herein are proprietary to Adobe
 * and its suppliers and are protected by all applicable intellectual
 * property laws, including trade secret and copyright laws.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe.
 */
declare(strict_types=1);

namespace Magento\SharedCatalog\Test\Unit\Model;

use Magento\SharedCatalog\Model\CustomerGroupManagement;
use PHPUnit\Framework\TestCase;

/**
 * Test for \Magento\SharedCatalog\Model\CustomerGroupManagement.
 */
class CustomerGroupManagementTest extends TestCase
{
    /**
     * @var CustomerGroupManagement
     */
    private $customerGroupManagement;

    /**
     * @inheritDoc
     */
    protected function setUp(): void
    {
        $this->customerGroupManagement = $this->createPartialMock(
            CustomerGroupManagement::class,
            ['getGroupIdsNotInSharedCatalogs']
        );
    }

    /**
     * @dataProvider isPrimaryCatalogAvailableDataProvider
     *
     * @param int|string $customerGroupId
     * @param bool $expected
     * @return void
     */
    public function testIsPrimaryCatalogAvailable(
        $customerGroupId,
        bool $expected
    ): void {
        $this->customerGroupManagement
            ->expects($this->once())
            ->method('getGroupIdsNotInSharedCatalogs')
            ->willReturn([1, 2]);
        $this->assertEquals(
            $expected,
            $this->customerGroupManagement->isPrimaryCatalogAvailable($customerGroupId)
        );
    }

    /**
     * @return array
     */
    public static function isPrimaryCatalogAvailableDataProvider(): array
    {
        return [
            'intGroupIdNotInSharedCatalog' => [1, true],
            'stringGroupIdNotInSharedCatalog' => ['1', true],
            'intGroupIdInSharedCatalog' => [5, false],
            'stringGroupIdInSharedCatalog' => ['5', false],
        ];
    }
}
