<?php
/**
 * ADOBE CONFIDENTIAL
 *
 * Copyright 2023 Adobe
 * All Rights Reserved.
 *
 * NOTICE: All information contained herein is, and remains
 * the property of Adobe and its suppliers, if any. The intellectual
 * and technical concepts contained herein are proprietary to Adobe
 * and its suppliers and are protected by all applicable intellectual
 * property laws, including trade secret and copyright laws.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe.
 */
declare(strict_types=1);

namespace Magento\SharedCatalog\Test\Fixture;

use Magento\Framework\Exception\NoSuchEntityException;
use Magento\Framework\Exception\InvalidArgumentException;
use Magento\Framework\DataObject;
use Magento\SharedCatalog\Api\CompanyManagementInterface;
use Magento\TestFramework\Fixture\DataFixtureInterface;

/**
 * Assigning company to shared catalog
 */
class AssignCompany implements DataFixtureInterface
{
    private const COMPANY = 'company';
    private const CATALOG_ID = 'catalog_id';

    /**
     * @var CompanyManagementInterface
     */
    private CompanyManagementInterface $companyManagement;

    /**
     * @param CompanyManagementInterface $companyManagement
     */
    public function __construct(CompanyManagementInterface $companyManagement)
    {
        $this->companyManagement = $companyManagement;
    }

    /**
     * @inheritdoc
     * @throws InvalidArgumentException|NoSuchEntityException
     */
    public function apply(array $data = []): ?DataObject
    {
        if (empty($data[self::CATALOG_ID])) {
            throw new InvalidArgumentException(__('"%field" is required', ['field' => self::CATALOG_ID]));
        }

        if (empty($data[self::COMPANY])) {
            throw new InvalidArgumentException(__('"%field" is required', ['field' => self::COMPANY]));
        }

        $this->companyManagement->assignCompanies((int)$data[self::CATALOG_ID], [$data[self::COMPANY]]);

        return null;
    }
}
